% General implementation of basic k-NN positioning .
%   Copyright  2020 University of Extremadura (UEx)

% This script implements the 1-NN with local coordinates and zoneId.
% -----------------------------------------

clc
addpath('data','load','utils','ips');
info = getDeploymentDefs();

% Structure to save ips information
 error = struct; 

% Loop over all the sets
for i=1:1:3
    
    % Loop over all the phones in each development 
    for j=1:1:size(info.set(i).phones,2)

    set = info.set(i);
    phone = info.set(i).phones(j);
    
    data = getDataForSet(set, phone, 0);
    
    % Accurate x,y,z positioning
    
    % Fingerprinting Positioning with 180 slots
    [rssMatrix, coordMatrix, idxTrain, idxTest] = change_to_matrix_notation(set, data);
    error.set(i).telf(j).all.errors = [];   
    [rssTrnMat,rssTstMat,coordTrnMat,coordTstMat] = splitTrnTst_fromMatrix_withIdx(set,rssMatrix,coordMatrix,idxTrain, idxTest);
    [prediction] = nn_algorithm(rssTstMat,rssTrnMat,coordTrnMat,1);
    [error.set(i).telf(j).all.errors error.set(i).telf(j).all.floor] = customError_3D(prediction, coordTstMat);

    
    % AVERAGE1: Fingerprinting Positioning using an average between different slots 
    [rssMatrix, coordMatrix, idxTrain, idxTest] = change_to_matrix_notation_average_slots(set, data,1);
    error.set(i).telf(j).average.errors = [];   
    [rssTrnMat,rssTstMat,coordTrnMat,coordTstMat] = splitTrnTst_fromMatrix_withIdx(set,rssMatrix,coordMatrix,idxTrain,idxTest);
    [prediction] = nn_algorithm(rssTstMat,rssTrnMat,coordTrnMat,1);
    [error.set(i).telf(j).average1.errors error.set(i).telf(j).average1.floor] = customError_3D(prediction, coordTstMat);
    
    % AVERAGE2: Fingerprinting Positioning using an average between different slots 
    [rssMatrix, coordMatrix, idxTrain, idxTest] = change_to_matrix_notation_average_slots(set, data,2);
    error.set(i).telf(j).average.errors = [];   
    [rssTrnMat,rssTstMat,coordTrnMat,coordTstMat] = splitTrnTst_fromMatrix_withIdx(set,rssMatrix,coordMatrix,idxTrain,idxTest);
    [prediction] = nn_algorithm(rssTstMat,rssTrnMat,coordTrnMat,1);
    [error.set(i).telf(j).average2.errors error.set(i).telf(j).average2.floor] = customError_3D(prediction, coordTstMat);
    
    % AVERAGE3: Fingerprinting Positioning using an average between different slots 
    [rssMatrix, coordMatrix, idxTrain, idxTest] = change_to_matrix_notation_average_slots(set, data,3);
    error.set(i).telf(j).average.errors = [];   
    [rssTrnMat,rssTstMat,coordTrnMat,coordTstMat] = splitTrnTst_fromMatrix_withIdx(set,rssMatrix,coordMatrix,idxTrain,idxTest);
    [prediction] = nn_algorithm(rssTstMat,rssTrnMat,coordTrnMat,1);
    [error.set(i).telf(j).average3.errors error.set(i).telf(j).average3.floor] = customError_3D(prediction, coordTstMat);
    
    % AVERAGE4: Fingerprinting Positioning using an average between different slots 
    [rssMatrix, coordMatrix, idxTrain, idxTest] = change_to_matrix_notation_average_slots(set, data,4);
    error.set(i).telf(j).average.errors = [];   
    [rssTrnMat,rssTstMat,coordTrnMat,coordTstMat] = splitTrnTst_fromMatrix_withIdx(set,rssMatrix,coordMatrix,idxTrain,idxTest);
    [prediction] = nn_algorithm(rssTstMat,rssTrnMat,coordTrnMat,1);
    [error.set(i).telf(j).average4.errors error.set(i).telf(j).average4.floor] = customError_3D(prediction, coordTstMat);
 
 
    % Fingerprinting Positioning using just one slot 
    data = getDataForSet(set, phone, 1);
    [rssMatrix, coordMatrix] = change_to_matrix_notation(set, data);
    error.set(i).telf(j).slot.errors = [];   
    [rssTrnMat,rssTstMat,coordTrnMat,coordTstMat] = splitTrnTst_fromMatrix_withIdx(set,rssMatrix,coordMatrix,idxTrain,idxTest);
    [prediction] = nn_algorithm(rssTstMat,rssTrnMat,coordTrnMat,1);
    [error.set(i).telf(j).slot.errors error.set(i).telf(j).slot.floor] = customError_3D(prediction, coordTstMat);
   
    % Tag positioning
    data = getDataForSet(set, phone, 0);
    % Fingerprinting Positioning with 180 slots
    [rssMatrix, zoneMatrix, idxTrain,  idxTest] = change_to_matrix_notatio_zonen(set, data);
    error.set(i).telf(j).all.zone = [];   
    [rssTrnMat,rssTstMat,coordTrnMat,coordTstMat] = splitTrnTst_fromMatrix_withIdx_zone(set,rssMatrix,zoneMatrix,idxTrain,idxTest);
    [prediction] = nn_algorithm(rssTstMat,rssTrnMat,coordTrnMat,1);
    [error.set(i).telf(j).all.zone] = customError_zone(prediction, coordTstMat);
    
    % Average1: Fingerprinting Positioning using an average between different slots 
    [rssMatrix, zoneMatrix, idxTrain, idxTest]  = change_to_matrix_notation_average_slots_zone(set, data,1);
    error.set(i).telf(j).average.zone = [];   
    [rssTrnMat,rssTstMat,coordTrnMat,coordTstMat] = splitTrnTst_fromMatrix_withIdx_zone(set,rssMatrix,zoneMatrix,idxTrain,idxTest);
    [prediction] = nn_algorithm(rssTstMat,rssTrnMat,coordTrnMat,1);
    [error.set(i).telf(j).average1.zone] = customError_zone(prediction, coordTstMat);
    
     % Average2: Fingerprinting Positioning using an average between different slots 
    [rssMatrix, zoneMatrix, idxTrain, idxTest]  = change_to_matrix_notation_average_slots_zone(set, data,2);
    error.set(i).telf(j).average.zone = [];   
    [rssTrnMat,rssTstMat,coordTrnMat,coordTstMat] = splitTrnTst_fromMatrix_withIdx_zone(set,rssMatrix,zoneMatrix,idxTrain,idxTest);
    [prediction] = nn_algorithm(rssTstMat,rssTrnMat,coordTrnMat,1);
    [error.set(i).telf(j).average2.zone] = customError_zone(prediction, coordTstMat);
    
     %  Average3: Fingerprinting Positioning using an average between different slots 
    [rssMatrix, zoneMatrix, idxTrain, idxTest]  = change_to_matrix_notation_average_slots_zone(set, data,3);
    error.set(i).telf(j).average.zone = [];   
    [rssTrnMat,rssTstMat,coordTrnMat,coordTstMat] = splitTrnTst_fromMatrix_withIdx_zone(set,rssMatrix,zoneMatrix,idxTrain,idxTest);
    [prediction] = nn_algorithm(rssTstMat,rssTrnMat,coordTrnMat,1);
    [error.set(i).telf(j).average3.zone] = customError_zone(prediction, coordTstMat);
    
     % Average4: Fingerprinting Positioning using an average between different slots 
    [rssMatrix, zoneMatrix, idxTrain, idxTest]  = change_to_matrix_notation_average_slots_zone(set, data,4);
    error.set(i).telf(j).average.zone = [];   
    [rssTrnMat,rssTstMat,coordTrnMat,coordTstMat] = splitTrnTst_fromMatrix_withIdx_zone(set,rssMatrix,zoneMatrix,idxTrain,idxTest);
    [prediction] = nn_algorithm(rssTstMat,rssTrnMat,coordTrnMat,1);
    [error.set(i).telf(j).average4.zone] = customError_zone(prediction, coordTstMat);
    
    % Fingerprinting Positioning using just one slot 
    data = getDataForSet( set, phone, 1);
    [rssMatrix, zoneMatrix, idxTrain, idxTest] = change_to_matrix_notatio_zonen(set, data);
    error.set(i).telf(j).slot.zone = [];   
    [rssTrnMat,rssTstMat,coordTrnMat,coordTstMat] = splitTrnTst_fromMatrix_withIdx_zone(set,rssMatrix,zoneMatrix,idxTrain,idxTest);
    [prediction] = nn_algorithm(rssTstMat,rssTrnMat,coordTrnMat,1);
    [error.set(i).telf(j).slot.zone] = customError_zone(prediction, coordTstMat);
  
    end
end
   
 save('error_v2','error'); 
 plot_CDF(info,error)
